import os
import requests
from PIL import Image
from flask import current_app
import uuid

def allowed_file(filename):
    ALLOWED_EXTENSIONS = {'png', 'jpg', 'jpeg', 'gif', 'webp'}
    return '.' in filename and filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS

def save_image(file, article_id=None):
    if file and allowed_file(file.filename):
        ext = file.filename.rsplit('.', 1)[1].lower()
        filename = f"{uuid.uuid4().hex}.{ext}"
    
        if article_id:
            image_dir = os.path.join(current_app.instance_path, 'uploads', 'images', str(article_id))
            thumbnail_dir = os.path.join(current_app.instance_path, 'uploads', 'thumbnails', str(article_id))
        else:
            image_dir = os.path.join(current_app.instance_path, 'uploads', 'images')
            thumbnail_dir = os.path.join(current_app.instance_path, 'uploads', 'thumbnails')
        
        os.makedirs(image_dir, exist_ok=True)
        os.makedirs(thumbnail_dir, exist_ok=True)
        
        image_path = os.path.join(image_dir, filename)
        file.save(image_path)
        
        thumbnail_path = os.path.join(thumbnail_dir, filename)
        try:
            with Image.open(image_path) as img:
                img.thumbnail((300, 300))
                img.save(thumbnail_path)
        except Exception as e:
            current_app.logger.error(f"Error creating thumbnail: {e}")
            thumbnail_path = None
        
        image_url = f"/uploads/images/{article_id}/{filename}" if article_id else f"/uploads/images/{filename}"
        thumbnail_url = f"/uploads/thumbnails/{article_id}/{filename}" if thumbnail_path and article_id else f"/uploads/thumbnails/{filename}" if thumbnail_path else None
        
        return image_url, thumbnail_url
    
    return None, None

def fetch_jubatimes_articles(section='home'):
    api_key = current_app.config['JTIMES_API_API']
    url = f'https://api.nytimes.com/svc/topstories/v2/{section}.json?api-key={api_key}'
    
    try:
        response = requests.get(url, timeout=10)
        response.raise_for_status()
        return response.json()
    except requests.RequestException as e:
        current_app.logger.error(f"Error fetching JBTimes data: {e}")
        return None