from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_msearch import Search
from flask_bcrypt import Bcrypt
from flask_jwt_extended import JWTManager
from flask_cors import CORS
from .config import Config

db = SQLAlchemy()
#search=Search(app, db)
bcrypt = Bcrypt()
jwt = JWTManager()
def create_app(config_class=Config):
    app = Flask(__name__)
    app.config.from_object(config_class)
    
    db.init_app(app)
    bcrypt.init_app(app)
    Search(app, db)
  
    jwt.init_app(app)
    CORS(app)
  
    from .routes import main
    from .auth import auth
    app.register_blueprint(main, url_prefix='/main')
    app.register_blueprint(auth, url_prefix='/auth')

    with app.app_context():
        db.create_all()
    
    return app