from app.config import Config
from functools import wraps
from flask import jsonify, request
from app.models import User
import jwt

def token_required(f):
    @wraps(f)
    def decorated(*args, **kwargs):
        token = None
        if 'x-access-token' in request.headers:
            token = request.headers['x-access-token']
           
        if not token:
            return jsonify({'status' : 'Token is missing !!'}), 401
  
        try:
            data = jwt.decode(token, Config.SECRET_KEY, algorithms=["HS256"])
            current_user = User.query\
                .filter_by(id = data['public_id'])\
                .first()
        except:
            print('tokens')
            return jsonify({
                'status' : 'Token is invalid, login again!!'
            }), 401
        return  f(current_user, *args, **kwargs)
  
    return decorated


def apiAuth_required(f):
    @wraps(f)
    def decorated(*args, **kwargs):
        token = None
        if 'api-key' in request.headers:
            token = request.headers['api-key']
        if not token:
            return jsonify({'message' : 'Token is missing !!'}), 401
  
        try:
            # decoding the payload to fetch the stored details
            data = jwt.decode(token, Config.SECRET_KEY,  algorithms=["HS256"])
            current_user = User.query\
                .filter_by(id = data['public_id'])\
                .first()
        except:
            return jsonify({
                'message' : 'Token is invalid !!'
            }), 401
        # returns the current logged in users context to the routes
        return  f(current_user, *args, **kwargs)
  
    return decorated